%%%script written by Karin Petrini on 09/04/2020 to get scores of accuracy
%%%and reaction times from 7 separate emotions and 3 intensities

clear variables;
close all;
clc;

% Get the folder name from the user
dirname = uigetdir(pwd);
%and move to that path location
cd(string(dirname));
% Get a directory structure of all text files in that directory
dirStruct = dir(fullfile(dirname,'*.txt'));

%%here I'm putting all the textdata and data from the four separate files
%%into one for a total of 126 data for that specific week (e.g. week1)
for i=1:length(dirStruct)
    if ~isempty(strfind(dirStruct(i).name,('_part_1')))
        fileToRead1 = dirStruct(i).name;
        delimiterIn = ' ';
        headerlinesIn = 3;
        rawData_P1 = importdata(fileToRead1,delimiterIn,headerlinesIn);
        textdata_P1 = rawData_P1.textdata(4:length(rawData_P1.textdata));
        data_A_P1=rawData_P1.data(:,1);
        data_RT_P1=rawData_P1.data(:,2);
    elseif ~isempty(strfind(dirStruct(i).name,('_part_2')))
        fileToRead1 = dirStruct(i).name;
        delimiterIn = ' ';
        headerlinesIn = 3;
        rawData_P2 = importdata(fileToRead1,delimiterIn,headerlinesIn);
        textdata_P2 = rawData_P2.textdata(4:length(rawData_P2.textdata));
        data_A_P2=rawData_P2.data(:,1);
        data_RT_P2=rawData_P2.data(:,2);
    elseif ~isempty(strfind(dirStruct(i).name,('_part_3')))
        fileToRead1 = dirStruct(i).name;
        delimiterIn = ' ';
        headerlinesIn = 3;
        rawData_P3 = importdata(fileToRead1,delimiterIn,headerlinesIn);
        textdata_P3 = rawData_P3.textdata(4:length(rawData_P3.textdata));
        data_A_P3=rawData_P3.data(:,1);
        data_RT_P3=rawData_P3.data(:,2);
    elseif ~isempty(strfind(dirStruct(i).name,('_part_4')))
        fileToRead1 = dirStruct(i).name;
        delimiterIn = ' ';
        headerlinesIn = 3;
        rawData_P4 = importdata(fileToRead1,delimiterIn,headerlinesIn);
        textdata_P4 = rawData_P4.textdata(4:length(rawData_P4.textdata));
        data_A_P4=rawData_P4.data(:,1);
        data_RT_P4=rawData_P4.data(:,2);
        
    end
end

all_textdata=[textdata_P1; textdata_P2; textdata_P3; textdata_P4];
all_data_A=[data_A_P1;data_A_P2;data_A_P3;data_A_P4];
all_data_RT=[data_RT_P1;data_RT_P2;data_RT_P3;data_RT_P4];


%%here I'm dividing the data by emotion and intensity by looking at all
%%data which is how we want to look at them in the analysis for each week
for a=1:length(all_textdata)
    if contains(all_textdata(a),('Surprise-low'))
        surprise_low(a)=1;
        if surprise_low(a)==1
            Adata_surprise_low(a) = all_data_A(a);
            RTdata_surprise_low(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Surprise-med'))
        surprise_med(a)=1;
        if surprise_med(a)==1
            Adata_surprise_med(a) = all_data_A(a);
            RTdata_surprise_med(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Surprise-high'))
        surprise_high(a)=1;
        if surprise_high(a)==1
            Adata_surprise_high(a) = all_data_A(a);
            RTdata_surprise_high(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Joy-low'))
        Joy_low(a)=1;
        if Joy_low(a)==1
            Adata_Joy_low(a) = all_data_A(a);
            RTdata_Joy_low(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Joy-med'))
        Joy_med(a)=1;
        if Joy_med(a)==1
            Adata_Joy_med(a) = all_data_A(a);
            RTdata_Joy_med(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Joy-high'))
        Joy_high(a)=1;
        if Joy_high(a)==1
            Adata_Joy_high(a) = all_data_A(a);
            RTdata_Joy_high(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Fear-low'))
        Fear_low(a)=1;
        if Fear_low(a)==1
            Adata_Fear_low(a) = all_data_A(a);
            RTdata_Fear_low(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Fear-med'))
        Fear_med(a)=1;
        if Fear_med(a)==1
            Adata_Fear_med(a) = all_data_A(a);
            RTdata_Fear_med(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Fear-high'))
        Fear_high(a)=1;
        if Fear_high(a)==1
            Adata_Fear_high(a) = all_data_A(a);
            RTdata_Fear_high(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Disgust-low'))
        Disgust_low(a)=1;
        if Disgust_low(a)==1
            Adata_Disgust_low(a) = all_data_A(a);
            RTdata_Disgust_low(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Disgust-med'))
        Disgust_med(a)=1;
        if Disgust_med(a)==1
            Adata_Disgust_med(a) = all_data_A(a);
            RTdata_Disgust_med(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Disgust-high'))
        Disgust_high(a)=1;
        if Disgust_high(a)==1
            Adata_Disgust_high(a) = all_data_A(a);
            RTdata_Disgust_high(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Anger-low'))
        Anger_low(a)=1;
        if Anger_low(a)==1
            Adata_Anger_low(a) = all_data_A(a);
            RTdata_Anger_low(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Anger-med'))
        Anger_med(a)=1;
        if Anger_med(a)==1
            Adata_Anger_med(a) = all_data_A(a);
            RTdata_Anger_med(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Anger-high'))
        Anger_high(a)=1;
        if Anger_high(a)==1
            Adata_Anger_high(a) = all_data_A(a);
            RTdata_Anger_high(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Sadness-low'))
        Sadness_low(a)=1;
        if Sadness_low(a)==1
            Adata_Sadness_low(a) = all_data_A(a);
            RTdata_Sadness_low(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Sadness-med'))
        Sadness_med(a)=1;
        if Sadness_med(a)==1
            Adata_Sadness_med(a) = all_data_A(a);
            RTdata_Sadness_med(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Sadness-high'))
        Sadness_high(a)=1;
        if Sadness_high(a)==1
            Adata_Sadness_high(a) = all_data_A(a);
            RTdata_Sadness_high(a) = all_data_RT(a);
        end
    elseif contains(all_textdata(a),('Neutral'))
        Neutral(a)=1;
        if Neutral(a)==1
            Adata_Neutral(a) = all_data_A(a);
            RTdata_Neutral(a) = all_data_RT(a);
        end
    end
    
end

%get rid of zeros B = A(A~=0)
Data_surprise_low_A = Adata_surprise_low(Adata_surprise_low~=0);
Data_surprise_med_A = Adata_surprise_med(Adata_surprise_med~=0);
Data_surprise_high_A = Adata_surprise_high(Adata_surprise_high~=0);
Data_joy_low_A = Adata_Joy_low(Adata_Joy_low~=0);
Data_joy_med_A = Adata_Joy_med(Adata_Joy_med~=0);
Data_joy_high_A = Adata_Joy_high(Adata_Joy_high~=0);
Data_fear_low_A = Adata_Fear_low(Adata_Fear_low~=0);
Data_fear_med_A = Adata_Fear_med(Adata_Fear_med~=0);
Data_fear_high_A = Adata_Fear_high(Adata_Fear_high~=0);
Data_disgust_low_A = Adata_Disgust_low(Adata_Disgust_low~=0);
Data_disgust_med_A = Adata_Disgust_med(Adata_Disgust_med~=0);
Data_disgust_high_A = Adata_Disgust_high(Adata_Disgust_high~=0);
Data_anger_low_A = Adata_Anger_low(Adata_Anger_low~=0);
Data_anger_med_A = Adata_Anger_med(Adata_Anger_med~=0);
Data_anger_high_A = Adata_Anger_high(Adata_Anger_high~=0);
Data_sadness_low_A = Adata_Sadness_low(Adata_Sadness_low~=0);
Data_sadness_med_A = Adata_Sadness_med(Adata_Sadness_med~=0);
Data_sadness_high_A = Adata_Sadness_high(Adata_Sadness_high~=0);
Data_neutral_A = Adata_Neutral(Adata_Neutral~=0);


Data_surprise_low_RT = RTdata_surprise_low(RTdata_surprise_low~=0);
Data_surprise_med_RT = RTdata_surprise_med(RTdata_surprise_med~=0);
Data_surprise_high_RT = RTdata_surprise_high(RTdata_surprise_high~=0);
Data_joy_low_RT = RTdata_Joy_low(RTdata_Joy_low~=0);
Data_joy_med_RT = RTdata_Joy_med(RTdata_Joy_med~=0);
Data_joy_high_RT = RTdata_Joy_high(RTdata_Joy_high~=0);
Data_fear_low_RT = RTdata_Fear_low(RTdata_Fear_low~=0);
Data_fear_med_RT = RTdata_Fear_med(RTdata_Fear_med~=0);
Data_fear_high_RT = RTdata_Fear_high(RTdata_Fear_high~=0);
Data_disgust_low_RT = RTdata_Disgust_low(RTdata_Disgust_low~=0);
Data_disgust_med_RT = RTdata_Disgust_med(RTdata_Disgust_med~=0);
Data_disgust_high_RT = RTdata_Disgust_high(RTdata_Disgust_high~=0);
Data_anger_low_RT = RTdata_Anger_low(RTdata_Anger_low~=0);
Data_anger_med_RT = RTdata_Anger_med(RTdata_Anger_med~=0);
Data_anger_high_RT = RTdata_Anger_high(RTdata_Anger_high~=0);
Data_sadness_low_RT = RTdata_Sadness_low(RTdata_Sadness_low~=0);
Data_sadness_med_RT = RTdata_Sadness_med(RTdata_Sadness_med~=0);
Data_sadness_high_RT = RTdata_Sadness_high(RTdata_Sadness_high~=0);
Data_neutral_RT = RTdata_Neutral(RTdata_Neutral~=0);
%%here I'm converting the number to correct (1) or wrong responses (0) for
%%each emotion category knowing that 1.Anger; 2. Disgust; 3. Fear; 4. Joy; 5.
%%Neutral; 6.Sadness; 7. Surprise. and I'm saving only the RT for the
%%correct responses as you probably want to analyse a change in RT when
%%participants correctly recognised the emotion rather than overall

for a=1:length(Data_surprise_low_A)
    if Data_surprise_low_A(a)==7
        Data_surprise_low_A(a) = 1;
    else
        Data_surprise_low_A(a) = 0;
        Data_surprise_low_RT(a) = 0;
    end
    if Data_surprise_med_A(a)==7
        Data_surprise_med_A(a) = 1;
    else
        Data_surprise_med_A(a) = 0;
        Data_surprise_med_RT(a) = 0;
    end
    
    if Data_surprise_high_A(a)==7
        Data_surprise_high_A(a) = 1;
    else
        Data_surprise_high_A(a) = 0;
        Data_surprise_high_RT(a) = 0;
    end
    if Data_joy_low_A(a)==4
        Data_joy_low_A(a) = 1;
    else
        Data_joy_low_A(a) = 0;
        Data_joy_low_RT(a) = 0;
    end
    if Data_joy_med_A(a)==4
        Data_joy_med_A(a) = 1;
    else
        Data_joy_med_A(a) = 0;
        Data_joy_med_RT(a) = 0;
    end
    if Data_joy_high_A(a)==4
        Data_joy_high_A(a) = 1;
    else
        Data_joy_high_A(a) = 0;
        Data_joy_high_RT(a) = 0;
    end
    if Data_fear_low_A(a)==3
        Data_fear_low_A(a) = 1;
    else
        Data_fear_low_A(a) = 0;
        Data_fear_low_RT(a) = 0;
    end
    if Data_fear_med_A(a)==3
        Data_fear_med_A(a) = 1;
    else
        Data_fear_med_A(a) = 0;
        Data_fear_med_RT(a) = 0;
    end
    if Data_fear_high_A(a)==3
        Data_fear_high_A(a) = 1;
    else
        Data_fear_high_A(a) = 0;
        Data_fear_high_RT(a) = 0;
    end
    if Data_disgust_low_A(a)==2
        Data_disgust_low_A(a) = 1;
    else
        Data_disgust_low_A(a) = 0;
        Data_disgust_low_RT(a) = 0;
    end
    if Data_disgust_med_A(a)==2
        Data_disgust_med_A(a) = 1;
    else
        Data_disgust_med_A(a) = 0;
        Data_disgust_med_RT(a) = 0;
    end
    if Data_disgust_high_A(a)==2
        Data_disgust_high_A(a) = 1;
    else
        Data_disgust_high_A(a) = 0;
        Data_disgust_high_RT(a) = 0;
    end
    if Data_anger_low_A(a)==1
        Data_anger_low_A(a) = 1;
    else
        Data_anger_low_A(a) = 0;
        Data_anger_low_RT(a) = 0;
    end
    if Data_anger_med_A(a)==1
        Data_anger_med_A(a) = 1;
    else
        Data_anger_med_A(a) = 0;
        Data_anger_med_RT(a) = 0;
    end
    if Data_anger_high_A(a)==1
        Data_anger_high_A(a) = 1;
    else
        Data_anger_high_A(a) = 0;
        Data_anger_high_RT(a) = 0;
    end
    if Data_sadness_low_A(a)==6
        Data_sadness_low_A(a) = 1;
    else
        Data_sadness_low_A(a) = 0;
        Data_sadness_low_RT(a) = 0;
    end
    if Data_sadness_med_A(a)==6
        Data_sadness_med_A(a) = 1;
    else
        Data_sadness_med_A(a) = 0;
        Data_sadness_med_RT(a) = 0;
    end
    if Data_sadness_high_A(a)==6
        Data_sadness_high_A(a) = 1;
    else
        Data_sadness_high_A(a) = 0;
        Data_sadness_high_RT(a) = 0;
    end
end

for a=1:length(Data_neutral_A)
    if Data_neutral_A(a)==5
        Data_neutral_A(a) = 1;
    else
        Data_neutral_A(a) = 0;
        Data_neutral_RT(a) = 0;
    end
end

%%here I calculate the accuracy score and RT across the diffrent clips/actors for
%%each emotion and intensity
score_surprise_low_A = mean(Data_surprise_low_A);
score_surprise_med_A = mean(Data_surprise_med_A);
score_surprise_high_A = mean(Data_surprise_high_A);
score_joy_low_A = mean(Data_joy_low_A);
score_joy_med_A = mean(Data_joy_med_A);
score_joy_high_A = mean(Data_joy_high_A);
score_fear_low_A = mean(Data_fear_low_A);
score_fear_med_A = mean(Data_fear_med_A);
score_fear_high_A = mean(Data_fear_high_A);
score_disgust_low_A = mean(Data_disgust_low_A);
score_disgust_med_A = mean(Data_disgust_med_A);
score_disgust_high_A = mean(Data_disgust_high_A);
score_anger_low_A = mean(Data_anger_low_A);
score_anger_med_A = mean(Data_anger_med_A);
score_anger_high_A = mean(Data_anger_high_A);
score_sadness_low_A = mean(Data_sadness_low_A);
score_sadness_med_A = mean(Data_sadness_med_A);
score_sadness_high_A = mean(Data_sadness_high_A);
score_neutral_A = mean(Data_neutral_A);
%%getting rid of the further zeros in RTs which are representing the
%%deleted values of RTs for wrong responses before to calculate the score
%%for RT for each emotion and intensity
Data_surprise_low_RT = Data_surprise_low_RT(Data_surprise_low_RT~=0);
Data_surprise_med_RT = Data_surprise_med_RT(Data_surprise_med_RT~=0);
Data_surprise_high_RT = Data_surprise_high_RT(Data_surprise_high_RT~=0);
Data_joy_low_RT = Data_joy_low_RT(Data_joy_low_RT~=0);
Data_joy_med_RT = Data_joy_med_RT(Data_joy_med_RT~=0);
Data_joy_high_RT = Data_joy_high_RT(Data_joy_high_RT~=0);
Data_fear_low_RT = Data_fear_low_RT(Data_fear_low_RT~=0);
Data_fear_med_RT = Data_fear_med_RT(Data_fear_med_RT~=0);
Data_fear_high_RT = Data_fear_high_RT(Data_fear_high_RT~=0);
Data_disgust_low_RT = Data_disgust_low_RT(Data_disgust_low_RT~=0);
Data_disgust_med_RT = Data_disgust_med_RT(Data_disgust_med_RT~=0);
Data_disgust_high_RT = Data_disgust_high_RT(Data_disgust_high_RT~=0);
Data_anger_low_RT = Data_anger_low_RT(Data_anger_low_RT~=0);
Data_anger_med_RT = Data_anger_med_RT(Data_anger_med_RT~=0);
Data_anger_high_RT = Data_anger_high_RT(Data_anger_high_RT~=0);
Data_sadness_low_RT = Data_sadness_low_RT(Data_sadness_low_RT~=0);
Data_sadness_med_RT = Data_sadness_med_RT(Data_sadness_med_RT~=0);
Data_sadness_high_RT = Data_sadness_high_RT(Data_sadness_high_RT~=0);
Data_neutral_RT = Data_neutral_RT(Data_neutral_RT~=0);

score_surprise_low_RT = mean(Data_surprise_low_RT);
score_surprise_med_RT = mean(Data_surprise_med_RT);
score_surprise_high_RT = mean(Data_surprise_high_RT);
score_joy_low_RT = mean(Data_joy_low_RT);
score_joy_med_RT = mean(Data_joy_med_RT);
score_joy_high_RT = mean(Data_joy_high_RT);
score_fear_low_RT = mean(Data_fear_low_RT);
score_fear_med_RT = mean(Data_fear_med_RT);
score_fear_high_RT = mean(Data_fear_high_RT);
score_disgust_low_RT = mean(Data_disgust_low_RT);
score_disgust_med_RT = mean(Data_disgust_med_RT);
score_disgust_high_RT = mean(Data_disgust_high_RT);
score_anger_low_RT = mean(Data_anger_low_RT);
score_anger_med_RT = mean(Data_anger_med_RT);
score_anger_high_RT = mean(Data_anger_high_RT);
score_sadness_low_RT = mean(Data_sadness_low_RT);
score_sadness_med_RT = mean(Data_sadness_med_RT);
score_sadness_high_RT = mean(Data_sadness_high_RT);
score_neutral_RT = mean(Data_neutral_RT);
%%here I'm saving the score for each week in the week folder for the
%%selected data and save it with group identification in the file name to help
%%identifying to which group participants are part of

if contains(dirStruct(i).name, 'MT')|| contains(dirStruct(i).name, 'mt')
    
    fid1 = fopen('Surprise_Accuracy_MT.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_surprise_low_A, score_surprise_med_A, score_surprise_high_A, score_surprise_low_RT, score_surprise_med_RT, score_surprise_high_RT);
    fclose(fid1);
    fid1 = fopen('Joy_Accuracy_MT.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_joy_low_A, score_joy_med_A, score_joy_high_A, score_joy_low_RT, score_joy_med_RT, score_joy_high_RT);
    fclose(fid1);
    fid1 = fopen('Fear_Accuracy_MT.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_fear_low_A, score_fear_med_A, score_fear_high_A, score_fear_low_RT, score_fear_med_RT, score_fear_high_RT);
    fclose(fid1);
    fid1 = fopen('Disgust_Accuracy_MT.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_disgust_low_A, score_disgust_med_A, score_disgust_high_A,score_disgust_low_RT, score_disgust_med_RT, score_disgust_high_RT);
    fclose(fid1);
    fid1 = fopen('Anger_Accuracy_MT.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_anger_low_A, score_anger_med_A, score_anger_high_A,score_anger_low_RT, score_anger_med_RT, score_anger_high_RT);
    fclose(fid1);
    fid1 = fopen('Sadness_Accuracy_MT.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_sadness_low_A, score_sadness_med_A, score_sadness_high_A,score_sadness_low_RT, score_sadness_med_RT, score_sadness_high_RT);
    fclose(fid1);
    fid1 = fopen('Neutral_Accuracy_MT.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f\n',score_neutral_A, score_neutral_RT);
    fclose(fid1);
    
elseif contains(dirStruct(i).name, 'ML')|| contains(dirStruct(i).name, 'ml')
    fid1 = fopen('Surprise_Accuracy_ML.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_surprise_low_A, score_surprise_med_A, score_surprise_high_A, score_surprise_low_RT, score_surprise_med_RT, score_surprise_high_RT);
    fclose(fid1);
    fid1 = fopen('Joy_Accuracy_ML.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_joy_low_A, score_joy_med_A, score_joy_high_A, score_joy_low_RT, score_joy_med_RT, score_joy_high_RT);
    fclose(fid1);
    fid1 = fopen('Fear_Accuracy_ML.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_fear_low_A, score_fear_med_A, score_fear_high_A, score_fear_low_RT, score_fear_med_RT, score_fear_high_RT);
    fclose(fid1);
    fid1 = fopen('Disgust_Accuracy_ML.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_disgust_low_A, score_disgust_med_A, score_disgust_high_A,score_disgust_low_RT, score_disgust_med_RT, score_disgust_high_RT);
    fclose(fid1);
    fid1 = fopen('Anger_Accuracy_ML.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_anger_low_A, score_anger_med_A, score_anger_high_A,score_anger_low_RT, score_anger_med_RT, score_anger_high_RT);
    fclose(fid1);
    fid1 = fopen('Sadness_Accuracy_ML.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_sadness_low_A, score_sadness_med_A, score_sadness_high_A,score_sadness_low_RT, score_sadness_med_RT, score_sadness_high_RT);
    fclose(fid1);
    fid1 = fopen('Neutral_Accuracy_ML.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f\n',score_neutral_A, score_neutral_RT);
    fclose(fid1);
    
    
elseif contains(dirStruct(i).name, 'C')|| contains(dirStruct(i).name, 'c')
    
    fid1 = fopen('Surprise_Accuracy_C.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_surprise_low_A, score_surprise_med_A, score_surprise_high_A, score_surprise_low_RT, score_surprise_med_RT, score_surprise_high_RT);
    fclose(fid1);
    fid1 = fopen('Joy_Accuracy_C.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_joy_low_A, score_joy_med_A, score_joy_high_A, score_joy_low_RT, score_joy_med_RT, score_joy_high_RT);
    fclose(fid1);
    fid1 = fopen('Fear_Accuracy_C.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_fear_low_A, score_fear_med_A, score_fear_high_A, score_fear_low_RT, score_fear_med_RT, score_fear_high_RT);
    fclose(fid1);
    fid1 = fopen('Disgust_Accuracy_C.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_disgust_low_A, score_disgust_med_A, score_disgust_high_A,score_disgust_low_RT, score_disgust_med_RT, score_disgust_high_RT);
    fclose(fid1);
    fid1 = fopen('Anger_Accuracy_C.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_anger_low_A, score_anger_med_A, score_anger_high_A,score_anger_low_RT, score_anger_med_RT, score_anger_high_RT);
    fclose(fid1);
    fid1 = fopen('Sadness_Accuracy_C.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f\n',score_sadness_low_A, score_sadness_med_A, score_sadness_high_A,score_sadness_low_RT, score_sadness_med_RT, score_sadness_high_RT);
    fclose(fid1);
    fid1 = fopen('Neutral_Accuracy_C.txt', 'a');
    fprintf(fid1, '%6.2f %6.2f\n',score_neutral_A, score_neutral_RT);
    fclose(fid1);
end